﻿
using System;
using System.Collections.Generic;


internal class AuthService
{
    private const string START_NODE = "<value>";
    private const string STOP_NODE = "</value>";

    private static int _startNodeLength = START_NODE.Length;

    internal string GetUserToken(string serviceEndpoint, VistACredentials vc)
    {
        var headers = new Dictionary<string, string>
        {
            { "Authorization", string.Format("Basic {0}", AuthHelper.GetEncodedSimpleAuthorizationHeader(vc.Access, vc.Verify)) }
        };

        var response = GetRequestorSpecialized.Get(serviceEndpoint, headers, WebConstants.XmlMimeType);
        if (response != null && response.Length > 0)
        {
            var start = response.IndexOf(START_NODE);

            var step1 = response.Substring(start + _startNodeLength);

            var stop = step1.IndexOf(STOP_NODE);

            return step1.Substring(0, stop);
        }

        return null;
    }
}

